/*
 * Decompiled with CFR 0.152.
 */
package src.born2kill.nw2png;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.ImageIcon;
import src.born2kill.nw2png.Listener;
import src.born2kill.nw2png.RenderObj;

public class NW2PNGHelper
implements Runnable {
    private BufferedImage tileset = null;
    private double scale = 1.0;
    private File sourceFile;
    private File outputFile;
    private Listener listener;
    private String graalDir = "C:\\Program Files\\Graal\\";
    private String filenamecacheDir;
    private String parsingLine;
    private boolean renderinggmap = false;
    private boolean filterOutput = true;
    private boolean splitImages = false;
    private boolean renderNPCs = true;
    private boolean renderChars = true;
    int ganiOffsetx = 0;
    int ganiOffsety = 0;
    ArrayList<String[]> tiledefs = new ArrayList();
    ArrayList<RenderObj> render_objects = new ArrayList();

    public Listener getListener() {
        return this.listener;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public boolean getFilter() {
        return this.filterOutput;
    }

    public void setFilter(boolean filter) {
        this.filterOutput = filter;
    }

    public boolean getRenderNPCs() {
        return this.renderNPCs;
    }

    public void setRenderNPCs(boolean filter) {
        this.renderNPCs = filter;
    }

    public boolean getRenderChars() {
        return this.renderChars;
    }

    public void setRenderChars(boolean filter) {
        this.renderChars = filter;
    }

    public boolean getSplit() {
        return this.splitImages;
    }

    public void setSplit(boolean splitImages) {
        this.splitImages = splitImages;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public String getGraalDir() {
        return this.graalDir;
    }

    public void setGraalDir(String graalDir) {
        this.graalDir = graalDir;
    }

    public BufferedImage getTileset() {
        return this.tileset;
    }

    public NW2PNGHelper(Listener listener) {
        this.setListener(listener);
    }

    public void setTileset(File tilesetFile) throws IOException {
        this.tileset = ImageIO.read(tilesetFile);
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public void generate() {
        Thread runner = new Thread(this);
        runner.start();
    }

    @Override
    public void run() {
        block13: {
            this.parsingLine = "";
            this.render_objects.clear();
            try {
                FileWriter fstream = new FileWriter("errorLog.txt", false);
                BufferedWriter out = new BufferedWriter(fstream);
                out.write("");
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String source_path = this.getSourceFile().getAbsolutePath();
            this.tiledefs = new ArrayList();
            this.CheckFILENAMECACHE();
            Date time = new Date();
            long startTime = time.getTime();
            try {
                if (source_path.endsWith(".nw")) {
                    BufferedImage renderNW = this.renderLevel(this.getSourceFile());
                    if (!this.renderinggmap) {
                        this.getListener().sendMessage("Saving image...");
                    }
                    try {
                        File file = this.getOutputFile();
                        ImageIO.write((RenderedImage)renderNW, "png", file);
                        if (!this.renderinggmap) {
                            this.getListener().sendMessage("The image has been saved successfully!");
                            time = new Date();
                            this.getListener().sendMessage("Parsed and rendered in " + (int)((time.getTime() - startTime) / 1000L) + " seconds.");
                        }
                        break block13;
                    }
                    catch (IOException e) {
                        this.getListener().sendMessage("Error: Couldn't save the image");
                    }
                    break block13;
                }
                if (source_path.endsWith(".gmap")) {
                    BufferedImage renderGmap = this.renderGmap(this.getSourceFile());
                    if (renderGmap == null) {
                        this.getListener().sendMessage("The image has been saved successfully!");
                        time = new Date();
                        this.getListener().sendMessage("Parsed and rendered in " + (int)((time.getTime() - startTime) / 1000L) + " seconds.");
                        return;
                    }
                    this.getListener().sendMessage("Saving image...");
                    try {
                        File file = this.getOutputFile();
                        ImageIO.write((RenderedImage)renderGmap, "png", file);
                        this.getListener().sendMessage("The image has been saved successfully!");
                        time = new Date();
                        this.getListener().sendMessage("Parsed and rendered in " + (int)((time.getTime() - startTime) / 1000L) + " seconds.");
                    }
                    catch (IOException e) {
                        this.renderinggmap = false;
                        this.writeLog(e);
                        this.getListener().sendMessage("Error: Couldn't save the image");
                    }
                }
            }
            catch (OutOfMemoryError e) {
                this.renderinggmap = false;
                this.writeLog(e);
                this.getListener().sendMessage("Error: Out of memory! Try MoreMemory.bat");
                this.getListener().doneGenerating();
            }
        }
        this.renderinggmap = false;
        this.getListener().doneGenerating();
    }

    /*
     * WARNING - void declaration
     */
    private BufferedImage renderLevel(File source) {
        String level_name = this.parsingLine = source.getName();
        String sourcePath = source.getAbsolutePath();
        int intTile = (int)(16.0 * this.getScale());
        int intDimension = intTile * 64;
        this.writeLog("Parsing level: " + this.parsingLine);
        try {
            void var20_52;
            FileReader level_in = new FileReader(source);
            BufferedReader level_reader = new BufferedReader(level_in);
            BufferedImage gmap_tiles = new BufferedImage(intDimension, intDimension, 3);
            Graphics2D tiles_g2d = gmap_tiles.createGraphics();
            if (this.getFilter()) {
                tiles_g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            } else {
                tiles_g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            }
            BufferedImage gmap_npcs = new BufferedImage(intDimension, intDimension, 3);
            Graphics2D npcs_g2d = gmap_npcs.createGraphics();
            if (this.getFilter()) {
                npcs_g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            } else {
                npcs_g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            }
            if (this.getSplit()) {
                this.render_objects.clear();
            }
            ArrayList<String[][]> ganis = new ArrayList<String[][]>();
            ArrayList<String> level_file = new ArrayList<String>();
            int level_highest_layer = 0;
            String level_file_line = level_reader.readLine();
            while (level_file_line != null) {
                String imgname;
                Pattern p;
                this.parsingLine = level_file_line = level_file_line.trim();
                if (level_file_line.startsWith("//")) {
                    level_file_line = level_reader.readLine();
                    continue;
                }
                if (level_file_line.startsWith("BOARD ")) {
                    level_file.add(level_file_line);
                    level_file_line = level_file_line.substring(6);
                    level_file_line = level_file_line.substring(level_file_line.indexOf(32) + 1);
                    level_file_line = level_file_line.substring(level_file_line.indexOf(32) + 1);
                    level_file_line = level_file_line.substring(level_file_line.indexOf(32) + 1);
                    int level_current_layer = Integer.parseInt(level_file_line.substring(0, level_file_line.indexOf(32)));
                    if (level_current_layer > level_highest_layer) {
                        level_highest_layer = level_current_layer;
                    }
                } else if (level_file_line.indexOf("addtiledef2") >= 0) {
                    level_file_line = level_file_line.trim();
                    level_file_line = level_file_line.substring(level_file_line.indexOf("addtiledef2") + 12);
                    level_file_line = level_file_line.replace("(", "");
                    level_file_line = level_file_line.replace(")", "");
                    level_file_line = level_file_line.replaceAll("\"", "");
                    level_file_line = level_file_line.replace("#L", level_name);
                    String REGEX = ",";
                    p = Pattern.compile(",");
                    String[] partitems = p.split(level_file_line);
                    imgname = partitems[0];
                    String string = partitems[1];
                    String drawx = partitems[2];
                    String drawy = partitems[3].substring(0, partitems[3].indexOf(";"));
                    String[] temparr = new String[]{string, imgname, drawx, drawy};
                    this.tiledefs.add(temparr);
                } else if (level_file_line.indexOf("addtiledef") >= 0 && level_file_line.indexOf("addtiledef2") < 0) {
                    level_file_line = level_file_line.trim();
                    level_file_line = level_file_line.substring(level_file_line.indexOf("addtiledef") + 11);
                    level_file_line = level_file_line.replace("(", "");
                    level_file_line = level_file_line.replace(")", "");
                    level_file_line = level_file_line.replaceAll("\"", "");
                    level_file_line = level_file_line.replace("#L", level_name);
                    String REGEX = ",";
                    p = Pattern.compile(",");
                    String[] partitems = p.split(level_file_line);
                    imgname = partitems[0];
                    String string = partitems[1];
                    String[] temparr = new String[]{string, imgname, Integer.toString(0), Integer.toString(0)};
                    this.tiledefs.add(temparr);
                } else {
                    if (!this.getRenderNPCs()) {
                        level_file_line = level_reader.readLine();
                        continue;
                    }
                    if (level_file_line.startsWith("NPC ")) {
                        double NPCx = 0.0;
                        double NPCy = 0.0;
                        String[] stringArray = level_file_line.split("\\s+");
                        NPCx = Integer.parseInt(stringArray[2]);
                        NPCy = Integer.parseInt(stringArray[3]);
                        level_reader.mark(20480);
                        String[] attrs = new String[15];
                        String npc_imgpart = level_reader.readLine();
                        boolean foundshowcharacter = false;
                        boolean foundsetimgpart = false;
                        boolean foundignorerender = false;
                        int j = 0;
                        while (j < 300) {
                            String[] npc_tokens;
                            String s;
                            int n;
                            int n2;
                            String[] stringArray2;
                            this.parsingLine = npc_imgpart = npc_imgpart.trim();
                            if (npc_imgpart.indexOf("join") > -1) {
                                npc_imgpart = npc_imgpart.replaceAll("\"", "");
                                npc_imgpart = npc_imgpart.replace("this.", "");
                                npc_imgpart = npc_imgpart.replace("(", " ");
                                npc_imgpart = npc_imgpart.replace(")", "");
                                npc_imgpart = npc_imgpart.replace(";", "");
                                String[] tokens = npc_imgpart.split("\\s+");
                                tokens[1] = tokens[1].trim();
                                String newImg = this.getJoin(tokens[1]);
                                if (newImg != null) {
                                    if (newImg.indexOf(":") < 0 && level_file_line.contains("-")) {
                                        level_file_line = level_file_line.replace("-", newImg);
                                    } else if (newImg.indexOf(":") > -1) {
                                        String[] newImgTokens;
                                        newImg = newImg.replaceAll("\\s+", "");
                                        stringArray2 = newImgTokens = newImg.split(",");
                                        n2 = newImgTokens.length;
                                        n = 0;
                                        while (n < n2) {
                                            s = stringArray2[n];
                                            String prop = s.substring(0, s.indexOf(":"));
                                            prop = prop.toLowerCase();
                                            String propvalue = s.substring(s.indexOf(":") + 1);
                                            propvalue = propvalue.toLowerCase();
                                            if (attrs[0] == null && prop.equals("gani")) {
                                                foundshowcharacter = true;
                                                attrs[0] = String.valueOf(propvalue) + ".gani";
                                            } else if (attrs[1] == null && prop.equals("skin")) {
                                                attrs[1] = propvalue;
                                            } else if (attrs[2] == null && prop.equals("coat")) {
                                                attrs[2] = propvalue;
                                            } else if (attrs[3] == null && prop.equals("sleeves")) {
                                                attrs[3] = propvalue;
                                            } else if (attrs[4] == null && prop.equals("shoes")) {
                                                attrs[4] = propvalue;
                                            } else if (attrs[5] == null && prop.equals("belt")) {
                                                attrs[5] = propvalue;
                                            } else if (attrs[6] == null && prop.equals("attr1")) {
                                                attrs[6] = propvalue;
                                            } else if (attrs[7] == null && prop.equals("attr2")) {
                                                attrs[7] = propvalue;
                                            } else if (attrs[8] == null && prop.equals("attr3")) {
                                                attrs[8] = propvalue;
                                            } else if (attrs[9] == null && prop.equals("sword")) {
                                                attrs[9] = propvalue;
                                            } else if (attrs[10] == null && prop.equals("shield")) {
                                                attrs[10] = propvalue;
                                            } else if (attrs[11] == null && prop.equals("head")) {
                                                attrs[11] = propvalue;
                                            } else if (attrs[12] == null && prop.equals("body")) {
                                                attrs[12] = propvalue;
                                            } else if (attrs[13] == null && prop.equals("param1")) {
                                                attrs[13] = propvalue;
                                            } else if (attrs[14] == null && prop.equals("dir")) {
                                                attrs[14] = propvalue;
                                            }
                                            ++n;
                                        }
                                    }
                                }
                            }
                            if (npc_imgpart.indexOf("setcharprop") > -1) {
                                String prop = npc_imgpart.substring(12, npc_imgpart.indexOf(",")).toLowerCase();
                                prop = prop.replaceAll("\\s+", "");
                                String propvalue = npc_imgpart.substring(npc_imgpart.indexOf(",") + 1, npc_imgpart.indexOf(";"));
                                propvalue = propvalue.trim();
                                if (prop.equals("#c0") && attrs[1] == null) {
                                    attrs[1] = propvalue;
                                } else if (prop.equals("#c1") && attrs[2] == null) {
                                    attrs[2] = propvalue;
                                } else if (prop.equals("#c2") && attrs[3] == null) {
                                    attrs[3] = propvalue;
                                } else if (prop.equals("#c3") && attrs[4] == null) {
                                    attrs[4] = propvalue;
                                } else if (prop.equals("#c4") && attrs[5] == null) {
                                    attrs[5] = propvalue;
                                } else if (prop.equals("#p1") && attrs[6] == null) {
                                    attrs[6] = propvalue;
                                } else if (prop.equals("#p2") && attrs[7] == null) {
                                    attrs[7] = propvalue;
                                } else if (prop.equals("#p3") && attrs[8] == null) {
                                    attrs[8] = propvalue;
                                } else if (prop.equals("#1") && attrs[9] == null) {
                                    attrs[9] = propvalue;
                                } else if (prop.equals("#2") && attrs[10] == null) {
                                    attrs[10] = propvalue;
                                } else if (prop.equals("#3") && attrs[11] == null) {
                                    attrs[11] = propvalue;
                                } else if (prop.equals("#8") && attrs[12] == null) {
                                    attrs[12] = propvalue;
                                }
                            }
                            if ((npc_imgpart.startsWith("dir") || npc_imgpart.startsWith("this.dir")) && attrs[14] == null) {
                                int findequal;
                                npc_imgpart = npc_imgpart.replaceAll("\\s+", "");
                                if ((npc_imgpart = npc_imgpart.replace("this.", "")).substring(0, (findequal = npc_imgpart.indexOf("=") + 1) - 1).equals("dir") && attrs[14] == null) {
                                    String test_dir = npc_imgpart.substring(findequal, findequal + 1);
                                    try {
                                        Integer.parseInt(test_dir);
                                        attrs[14] = npc_imgpart.substring(findequal, findequal + 1);
                                    }
                                    catch (Exception e) {
                                        this.writeLog(e);
                                    }
                                }
                            } else if (npc_imgpart.trim().startsWith("x") || npc_imgpart.trim().startsWith("this.x")) {
                                Double newX;
                                npc_imgpart = npc_imgpart.trim();
                                npc_imgpart = npc_imgpart.replace("this.", "");
                                npc_imgpart = npc_imgpart.replaceAll("\\s+", "");
                                if ((npc_imgpart = npc_imgpart.replace(";", "")).indexOf("++") > -1) {
                                    NPCx += 1.0;
                                } else if (npc_imgpart.indexOf("--") > -1) {
                                    NPCx -= 1.0;
                                } else if (npc_imgpart.indexOf("+=") > -1) {
                                    npc_tokens = npc_imgpart.split("\\+=");
                                    NPCx += this.findDouble(npc_tokens[1]);
                                } else if (npc_imgpart.indexOf("-=") > -1) {
                                    npc_tokens = npc_imgpart.split("-=");
                                    NPCx -= this.findDouble(npc_tokens[1]);
                                } else if (npc_imgpart.indexOf("=") > -1 && (newX = Double.valueOf(this.findDouble((npc_tokens = npc_imgpart.split("="))[1]))) >= 0.0) {
                                    NPCx = this.findDouble(npc_tokens[1]);
                                }
                            } else if (npc_imgpart.trim().startsWith("y") || npc_imgpart.trim().startsWith("this.y")) {
                                Double newY;
                                npc_imgpart = npc_imgpart.trim();
                                npc_imgpart = npc_imgpart.replace("this.", "");
                                npc_imgpart = npc_imgpart.replaceAll("\\s+", "");
                                if ((npc_imgpart = npc_imgpart.replace(";", "")).indexOf("++") > -1) {
                                    NPCy += 1.0;
                                } else if (npc_imgpart.indexOf("--") > -1) {
                                    NPCy -= 1.0;
                                } else if (npc_imgpart.indexOf("+=") > -1) {
                                    npc_tokens = npc_imgpart.split("\\+=");
                                    NPCy += this.findDouble(npc_tokens[1]);
                                } else if (npc_imgpart.indexOf("-=") > -1) {
                                    npc_tokens = npc_imgpart.split("-=");
                                    NPCy -= this.findDouble(npc_tokens[1]);
                                } else if (npc_imgpart.indexOf("=") > -1 && (newY = Double.valueOf(this.findDouble((npc_tokens = npc_imgpart.split("="))[1]))) >= 0.0) {
                                    NPCy = this.findDouble(npc_tokens[1]);
                                }
                            } else if (npc_imgpart.startsWith("this.")) {
                                String[] checkFor = new String[]{"attr[1]", "attr[2]", "attr[3]", "body", "bodyimg", "colors[0]", "colors[1]", "colors[2]", "colors[3]", "colors[4]", "head", "headimg", "ignorerender", "shield", "shieldimg", "sword", "swordimg"};
                                String prop = npc_imgpart = npc_imgpart.replaceAll("\"", "");
                                boolean foundAttr = false;
                                stringArray2 = checkFor;
                                n2 = checkFor.length;
                                n = 0;
                                while (n < n2) {
                                    s = stringArray2[n];
                                    if (npc_imgpart.indexOf(s) > -1) {
                                        foundAttr = true;
                                        break;
                                    }
                                    ++n;
                                }
                                if (foundAttr) {
                                    if (npc_imgpart.indexOf("=") >= 0) {
                                        prop = npc_imgpart.substring(5, npc_imgpart.indexOf("=")).toLowerCase();
                                    }
                                    prop = prop.replaceAll("\\s+", "");
                                    String propvalue = npc_imgpart.substring(npc_imgpart.indexOf("=") + 1, npc_imgpart.indexOf(";"));
                                    propvalue = propvalue.trim();
                                    if (prop.equals("colors[0]") && attrs[1] == null) {
                                        attrs[1] = propvalue;
                                    } else if (prop.equals("colors[1]") && attrs[2] == null) {
                                        attrs[2] = propvalue;
                                    } else if (prop.equals("colors[2]") && attrs[3] == null) {
                                        attrs[3] = propvalue;
                                    } else if (prop.equals("colors[3]") && attrs[4] == null) {
                                        attrs[4] = propvalue;
                                    } else if (prop.equals("colors[4]") && attrs[5] == null) {
                                        attrs[5] = propvalue;
                                    } else if (prop.equals("attr[1]") && attrs[6] == null) {
                                        attrs[6] = propvalue;
                                    } else if (prop.equals("attr[2]") && attrs[7] == null) {
                                        attrs[7] = propvalue;
                                    } else if (prop.equals("attr[3]") && attrs[8] == null) {
                                        attrs[8] = propvalue;
                                    } else if ((prop.equals("sword") || prop.equals("swordimg")) && attrs[9] == null) {
                                        attrs[9] = propvalue;
                                    } else if ((prop.equals("shield") || prop.equals("shieldimg")) && attrs[10] == null) {
                                        attrs[10] = propvalue;
                                    } else if ((prop.equals("head") || prop.equals("headimg")) && attrs[11] == null) {
                                        attrs[11] = propvalue;
                                    } else if ((prop.equals("body") || prop.equals("bodyimg")) && attrs[12] == null) {
                                        attrs[12] = propvalue;
                                    } else if (prop.equals("ignorerender") && propvalue.equals("true")) {
                                        foundignorerender = true;
                                    }
                                }
                            }
                            if (npc_imgpart.startsWith("showcharacter") || npc_imgpart.startsWith("this.showcharacter")) {
                                foundshowcharacter = true;
                                if (!this.getRenderChars()) {
                                    foundignorerender = true;
                                }
                            } else if ((npc_imgpart.startsWith("setcharani") || npc_imgpart.startsWith("this.setcharani")) && attrs[0] == null) {
                                String[] tokens;
                                npc_imgpart = npc_imgpart.replace("this.", "");
                                npc_imgpart = npc_imgpart.replace("(", " ");
                                npc_imgpart = npc_imgpart.replace(")", "");
                                npc_imgpart = npc_imgpart.replaceAll("\"", "");
                                npc_imgpart = npc_imgpart.replace("setcharani", "");
                                npc_imgpart = npc_imgpart.replace(";", "");
                                if ((npc_imgpart = npc_imgpart.trim()).indexOf(",") > -1 && (tokens = npc_imgpart.split(",")).length > 0) {
                                    String ganiname = tokens[0].toLowerCase().trim();
                                    String ganiparam = null;
                                    if (tokens.length > 1) {
                                        ganiparam = tokens[1].toLowerCase().trim();
                                    }
                                    if (ganiname.indexOf("[") > -1) {
                                        ganiname = ganiname.substring(0, ganiname.indexOf("["));
                                    }
                                    attrs[0] = String.valueOf(ganiname) + ".gani";
                                    attrs[13] = ganiparam;
                                }
                            } else {
                                if (npc_imgpart.startsWith("setimgpart") || npc_imgpart.startsWith("this.setimgpart")) {
                                    npc_imgpart = npc_imgpart.replaceAll("\"", "");
                                    npc_imgpart = npc_imgpart.replace("this.", "");
                                    npc_imgpart = npc_imgpart.replace("(", " ");
                                    npc_imgpart = npc_imgpart.replace(")", "");
                                    int startparse = npc_imgpart.indexOf(",");
                                    int endparse = npc_imgpart.indexOf(")") > -1 ? npc_imgpart.indexOf(")") : npc_imgpart.indexOf(";");
                                    String imgname2 = npc_imgpart.substring(npc_imgpart.indexOf(" ") + 1, startparse);
                                    String partdata = npc_imgpart.substring(startparse, endparse);
                                    partdata = partdata.replaceAll("\\s+", "");
                                    String imgpartvalues = partdata.replace(",", " ");
                                    if (!foundignorerender) {
                                        level_file.add("NPC " + imgname2 + " " + NPCx + " " + NPCy + imgpartvalues);
                                    }
                                    foundsetimgpart = true;
                                    break;
                                }
                                if (npc_imgpart.startsWith("NPCEND")) {
                                    if (attrs[0] == null && !foundshowcharacter || foundignorerender || !this.getRenderChars()) break;
                                    if (attrs[0] == null) {
                                        attrs[0] = "idle.gani";
                                    }
                                    String[] pos = new String[]{String.valueOf(NPCx), String.valueOf(NPCy)};
                                    String[][] concat = new String[][]{attrs, pos};
                                    ganis.add(concat);
                                    break;
                                }
                            }
                            npc_imgpart = level_reader.readLine();
                            ++j;
                        }
                        if (!(foundsetimgpart || level_file_line.startsWith("NPC -") || foundignorerender)) {
                            level_file.add(String.valueOf(level_file_line) + " 0 0 -1 -1");
                        }
                        level_reader.reset();
                    }
                }
                level_file_line = level_reader.readLine();
            }
            level_in.close();
            int[][][] level_tiles = new int[64][64][level_highest_layer + 1];
            int level_y = 0;
            while (level_y < level_tiles.length) {
                int level_x = 0;
                while (level_x < level_tiles[level_y].length) {
                    int level_layer = 1;
                    while (level_layer < level_tiles[level_y][level_x].length) {
                        level_tiles[level_y][level_x][level_layer] = -1;
                        ++level_layer;
                    }
                    ++level_x;
                }
                ++level_y;
            }
            ArrayList<String[]> level_npcs = new ArrayList<String[]>();
            for (String level_line : level_file) {
                String string = level_line;
                if (string.startsWith("BOARD ")) {
                    String string2;
                    int tiles_width;
                    String string3 = string.substring(6);
                    int tiles_start = Integer.parseInt(string3.substring(0, string3.indexOf(32)));
                    String string4 = string3.substring(string3.indexOf(32) + 1);
                    int tiles_height = Integer.parseInt(string4.substring(0, string4.indexOf(32)));
                    if (tiles_height > 63) {
                        tiles_height = 63;
                    }
                    if ((tiles_width = Integer.parseInt((string2 = string4.substring(string4.indexOf(32) + 1)).substring(0, string2.indexOf(32)))) > 64) {
                        tiles_width = 64;
                    }
                    String string5 = string2.substring(string2.indexOf(32) + 1);
                    int tiles_layer = Integer.parseInt(string5.substring(0, string5.indexOf(32)));
                    String string6 = string5.substring(string5.indexOf(32) + 1);
                    int level_x = tiles_start;
                    while (level_x < tiles_width) {
                        level_tiles[tiles_height][level_x][tiles_layer] = this.getTileNumber(string6.substring(level_x * 2, level_x * 2 + 2));
                        ++level_x;
                    }
                    continue;
                }
                if (!this.getRenderNPCs() || !string.startsWith("NPC ")) continue;
                String string7 = string.substring(4);
                String REGEX = " ";
                Pattern p = Pattern.compile(" ");
                String[] partitems = p.split(string7);
                String image_name = partitems[0];
                int image_x = this.findInt(partitems[1]);
                int image_y = this.findInt(partitems[2]);
                int image_dx = this.findInt(partitems[3]);
                int image_dy = this.findInt(partitems[4]);
                int image_dw = this.findInt(partitems[5]);
                int image_dh = this.findInt(partitems[6]);
                if (image_x < -64 || image_x > 127) {
                    this.getListener().sendMessage("Warning : The images x of " + image_name + " is " + (image_x < -64 ? "smaller then -64" : "bigger then 127"));
                    continue;
                }
                if (image_y < -64 || image_y > 127) {
                    this.getListener().sendMessage("Warning : The images y of " + image_name + " is " + (image_y < -64 ? "smaller then -64" : "bigger then 127"));
                    continue;
                }
                String[] temp_arr = new String[]{image_name, Integer.toString(image_x), Integer.toString(image_y), Integer.toString(image_dx), Integer.toString(image_dy), Integer.toString(image_dw), Integer.toString(image_dh), level_name};
                level_npcs.add(temp_arr);
            }
            BufferedImage finaltileset = new BufferedImage(this.tileset.getWidth(), this.tileset.getHeight(), 2);
            Graphics g = finaltileset.getGraphics();
            g.drawImage(this.tileset, 0, 0, null);
            for (String[] stringArray : this.tiledefs) {
                if (!level_name.startsWith(stringArray[0])) continue;
                try {
                    BufferedImage tiledef_image = ImageIO.read(new File(this.getImageLocation(stringArray[1])));
                    if (tiledef_image == null) continue;
                    g.drawImage(tiledef_image, this.findInt(stringArray[2]), this.findInt(stringArray[3]), null);
                }
                catch (IOException e) {
                    this.writeLog(e);
                    this.getListener().sendMessage("Error: Couldn't load the file " + stringArray[1]);
                }
            }
            boolean bl = false;
            while (var20_52 < level_tiles.length) {
                int level_x = 0;
                while (level_x < level_tiles[var20_52].length) {
                    int level_layer = 0;
                    while (level_layer < level_tiles[var20_52][level_x].length) {
                        if (level_tiles[var20_52][level_x][level_layer] >= 0) {
                            int[] tile_xy = this.getTileXY(level_tiles[var20_52][level_x][level_layer]);
                            tiles_g2d.drawImage(finaltileset, level_x * intTile, (int)(var20_52 * intTile), level_x * intTile + intTile, (int)(var20_52 * intTile + intTile), tile_xy[0], tile_xy[1], tile_xy[0] + 16, tile_xy[1] + 16, null);
                        }
                        ++level_layer;
                    }
                    ++level_x;
                }
                ++var20_52;
            }
            for (String[][] stringArray : ganis) {
                if (stringArray[0][12] != null && !this.getRenderChars()) continue;
                BufferedImage gani_render = this.getGani(stringArray[0]);
                if (gani_render == null) {
                    this.getListener().sendMessage("Warning : Couldn't render the gani " + stringArray[0][0]);
                    continue;
                }
                int NPCx = (int)(Double.parseDouble(stringArray[1][0]) * (double)intTile + (double)((int)((double)this.ganiOffsetx * this.getScale())));
                int NPCy = (int)(Double.parseDouble(stringArray[1][1]) * (double)intTile + (double)((int)((double)this.ganiOffsety * this.getScale())));
                int NPCw = (int)((double)gani_render.getWidth() * this.getScale());
                int NPCh = (int)((double)gani_render.getHeight() * this.getScale());
                int[] arr = new int[]{NPCx, NPCy, NPCw, NPCh};
                this.render_objects.add(new RenderObj(gani_render, arr, level_name, 2));
            }
            for (String[] stringArray : level_npcs) {
                if (stringArray[0] == null || stringArray[0].toLowerCase().contains("light")) continue;
                int image_x = this.findInt(stringArray[1]);
                int image_y = this.findInt(stringArray[2]);
                int image_dx = this.findInt(stringArray[3]);
                int image_dy = this.findInt(stringArray[4]);
                int image_dw = this.findInt(stringArray[5]);
                int image_dh = this.findInt(stringArray[6]);
                try {
                    if (this.getImageLocation(stringArray[0]) == null) {
                        stringArray[0] = null;
                        continue;
                    }
                    BufferedImage npc_image = ImageIO.read(new File(this.getImageLocation(stringArray[0])));
                    if (npc_image == null) {
                        this.getListener().sendMessage("Warning : Unknown image type " + stringArray[0].substring(stringArray[0].lastIndexOf(".") + 1).toUpperCase());
                        continue;
                    }
                    image_dw = image_dw == -1 ? npc_image.getWidth() : image_dw;
                    image_dh = image_dh == -1 ? npc_image.getHeight() : image_dh;
                    int render_x = image_x * intTile;
                    int render_y = image_y * intTile;
                    int render_w = (int)((double)image_dw * this.getScale());
                    int render_h = (int)((double)image_dh * this.getScale());
                    int[] arr = new int[]{render_x, render_y, render_x + render_w, render_y + render_h, image_dx, image_dy, image_dx + image_dw, image_dy + image_dh};
                    this.render_objects.add(new RenderObj(npc_image, arr, level_name, 1));
                }
                catch (IOException e) {
                    this.writeLog(e);
                    this.getListener().sendMessage("Warning : Couldn't find the image " + stringArray[0]);
                }
            }
            if (!this.renderinggmap || this.getSplit()) {
                this.render_objects = this.sortRender(this.render_objects);
                for (RenderObj renderObj : this.render_objects) {
                    BufferedImage img = renderObj.getImg();
                    int[] arr = renderObj.getData();
                    if (arr.length == 4) {
                        npcs_g2d.drawImage(img, arr[0], arr[1], arr[2], arr[3], null);
                        continue;
                    }
                    if (arr.length != 8) continue;
                    npcs_g2d.drawImage(img, arr[0], arr[1], arr[2], arr[3], arr[4], arr[5], arr[6], arr[7], null);
                }
            }
            if (!this.renderinggmap) {
                this.getListener().sendMessage("Rendering and saving the image...");
            }
            npcs_g2d.dispose();
            if (this.getRenderNPCs()) {
                tiles_g2d.drawImage((Image)gmap_npcs, 0, 0, null);
            }
            tiles_g2d.dispose();
            return gmap_tiles;
        }
        catch (IOException e) {
            this.writeLog(e);
            this.getListener().sendMessage("Error: Couldn't load the file " + sourcePath.substring(sourcePath.lastIndexOf(File.separator) + 1));
        }
        catch (OutOfMemoryError e) {
            this.renderinggmap = false;
            this.writeLog(e);
            this.getListener().sendMessage("Error: Out of memory! Try MoreMemory.bat");
            this.getListener().doneGenerating();
        }
        catch (NullPointerException e) {
            this.writeLog(e);
        }
        return null;
    }

    private ArrayList<RenderObj> sortRender(ArrayList<RenderObj> obj) {
        int a = 0;
        while (a < obj.size()) {
            int b = a + 1;
            while (b < obj.size()) {
                if (obj.get(b).getData()[1] + obj.get(b).getLayer() * 16 < obj.get(a).getData()[1] + obj.get(a).getLayer() * 16) {
                    RenderObj results = obj.get(b);
                    obj.set(b, obj.get(a));
                    obj.set(a, results);
                }
                ++b;
            }
            ++a;
        }
        return obj;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BufferedImage renderGmap(File source) {
        int intTile = (int)(16.0 * this.getScale());
        int intDimension = intTile * 64;
        this.renderinggmap = true;
        String sourcePath = source.getAbsolutePath();
        try {
            int draw_y;
            int draw_x;
            FileReader gmap_in = new FileReader(source);
            BufferedReader gmap_reader = new BufferedReader(gmap_in);
            int gmap_width = 0;
            int gmap_height = 0;
            boolean parselevels = false;
            String[] levels = new String[]{};
            String gmap_line = gmap_reader.readLine();
            int gmap_yrender = 0;
            while (gmap_line != null) {
                if (gmap_width < 0 || gmap_height < 0) break;
                if (gmap_line.startsWith("LEVELNAMESEND")) {
                    parselevels = false;
                    gmap_line = gmap_reader.readLine();
                    continue;
                }
                if (gmap_line.startsWith("WIDTH ")) {
                    gmap_width = Integer.parseInt(gmap_line.substring(6));
                    levels = new String[gmap_width * gmap_height];
                } else if (gmap_line.startsWith("HEIGHT ")) {
                    gmap_height = Integer.parseInt(gmap_line.substring(7));
                    levels = new String[gmap_width * gmap_height];
                } else if (gmap_line.startsWith("LEVELNAMES")) {
                    parselevels = true;
                } else if (parselevels) {
                    String[] level_tokens = gmap_line.split(",");
                    if (level_tokens.length > gmap_width) {
                        this.getListener().sendMessage("Error: GMAP format is incorrent!");
                        return null;
                    }
                    int i = 0;
                    while (i < level_tokens.length) {
                        String levelname = level_tokens[i].replaceAll("\"", "");
                        levelname = levelname.trim();
                        if (i + gmap_yrender * gmap_width < levels.length) {
                            levels[i + gmap_yrender * gmap_width] = levelname;
                        } else {
                            this.getListener().sendMessage("Error: Trouble parsing GMAP level data!");
                        }
                        ++i;
                    }
                    ++gmap_yrender;
                }
                gmap_line = gmap_reader.readLine();
            }
            int gmap_image_width = gmap_width * intDimension;
            int gmap_image_height = gmap_height * intDimension;
            BufferedImage gmapImage = new BufferedImage(gmap_image_width, gmap_image_height, 2);
            Graphics g = gmapImage.getGraphics();
            g.setColor(new Color(0));
            g.fillRect(0, 0, gmapImage.getWidth(), gmapImage.getHeight());
            int i = 0;
            while (i < levels.length) {
                File nwFile = new File(String.valueOf(sourcePath.substring(0, sourcePath.lastIndexOf(File.separator) + 1)) + levels[i]);
                BufferedImage nw_render = this.renderLevel(nwFile);
                if (nw_render != null) {
                    this.getListener().sendMessage("Rendering level: " + nwFile.getName());
                    draw_x = i % gmap_width * nw_render.getWidth();
                    draw_y = i / gmap_width * nw_render.getHeight();
                    if (this.getSplit()) {
                        try {
                            String partsDir = this.getOutputFile().getAbsolutePath();
                            partsDir = String.valueOf(partsDir.substring(0, partsDir.lastIndexOf("."))) + File.separator;
                            String nwName = nwFile.getName().substring(0, nwFile.getName().length() - 3);
                            File file = new File(String.valueOf(partsDir) + nwName + ".png");
                            file.getParentFile().mkdir();
                            ImageIO.write((RenderedImage)nw_render, "png", file);
                        }
                        catch (IOException e) {
                            this.writeLog(e);
                            this.getListener().sendMessage("Error: Couldn't save the image " + nwFile.getName().substring(0, nwFile.getName().length() - 3) + ".png");
                        }
                    } else {
                        g.drawImage(nw_render, draw_x, draw_y, null);
                    }
                }
                ++i;
            }
            if (this.getSplit()) {
                return null;
            }
            if (this.getRenderNPCs()) {
                this.render_objects = this.sortRender(this.render_objects);
                for (RenderObj obj : this.render_objects) {
                    int lvlcoord = 0;
                    int i2 = 0;
                    while (i2 < levels.length) {
                        if (obj.getLevel().equals(levels[i2])) {
                            lvlcoord = i2;
                            break;
                        }
                        ++i2;
                    }
                    draw_x = lvlcoord % gmap_width * intDimension;
                    draw_y = lvlcoord / gmap_width * intDimension;
                    BufferedImage img = obj.getImg();
                    int[] arr = obj.getData();
                    if (arr.length == 4) {
                        g.drawImage(img, draw_x + arr[0], draw_y + arr[1], arr[2], arr[3], null);
                        continue;
                    }
                    if (arr.length != 8) continue;
                    g.drawImage(img, draw_x + arr[0], draw_y + arr[1], draw_x + arr[2], draw_y + arr[3], arr[4], arr[5], arr[6], arr[7], null);
                }
            }
            return gmapImage;
        }
        catch (FileNotFoundException e) {
            this.writeLog(e);
        }
        catch (IOException e) {
            this.writeLog(e);
        }
        catch (NullPointerException e) {
            this.writeLog(e);
        }
        this.getListener().sendMessage("Error: GMAP was unable to be rendered for an unknown reason.");
        return null;
    }

    private int getTileNumber(String tile_string) {
        String base64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        return base64.indexOf(tile_string.substring(0, 1)) * 64 + base64.indexOf(tile_string.substring(1, 2));
    }

    private int[] getTileXY(int tile_number) {
        int[] tile_xy = new int[]{(tile_number % 16 + tile_number / 512 * 16) * 16, tile_number / 16 % 32 * 16};
        return tile_xy;
    }

    private void CheckFILENAMECACHE() {
        File filecheck;
        this.filenamecacheDir = this.getGraalDir();
        if (!this.filenamecacheDir.endsWith("\\")) {
            this.filenamecacheDir = String.valueOf(this.filenamecacheDir) + "\\";
        }
        if (!(filecheck = new File(String.valueOf(this.filenamecacheDir) + "FILENAMECACHE.txt")).exists()) {
            this.getListener().sendMessage("Error: Failed to find FILENAMECACHE.txt in " + this.filenamecacheDir + ", falling back on C:\\Program Files\\Graal\\...");
            this.filenamecacheDir = "C:\\Program Files\\Graal\\";
            File filecheck2 = new File(String.valueOf(this.filenamecacheDir) + "FILENAMECACHE.txt");
            if (!filecheck2.exists()) {
                this.getListener().sendMessage("Error: Failed to find FILENAMECACHE.txt on fallback search.");
            }
        }
    }

    private String getImageLocation(String imageName) {
        String GraalFolder = this.filenamecacheDir;
        if (imageName.equals("-")) {
            return null;
        }
        if (imageName.toLowerCase().endsWith(".mng")) {
            this.getListener().sendMessage("Warning: Does not support .MNG for " + imageName);
            return null;
        }
        try {
            FileReader filenamecache = new FileReader(String.valueOf(GraalFolder) + "FILENAMECACHE.txt");
            BufferedReader cache_scan = new BufferedReader(filenamecache);
            String cache_scan_line = cache_scan.readLine();
            while (cache_scan_line != null) {
                if (cache_scan_line.indexOf("\\" + imageName) > -1 || cache_scan_line.startsWith(imageName)) {
                    return String.valueOf(GraalFolder) + cache_scan_line.substring(0, cache_scan_line.indexOf(","));
                }
                cache_scan_line = cache_scan.readLine();
            }
        }
        catch (FileNotFoundException e) {
            this.writeLog(e);
        }
        catch (IOException e) {
            this.writeLog(e);
        }
        return GraalFolder;
    }

    private BufferedImage getGani(String[] attr) {
        String ganiName = attr[0];
        if (ganiName == null) {
            return null;
        }
        int dir = 2;
        if (attr[14] != null) {
            dir = Integer.parseInt(attr[14]);
        }
        this.ganiOffsety = 0;
        this.ganiOffsetx = 0;
        String[] defaultcolors = new String[]{"white", "yellow", "orange", "pink", "red", "darkred", "lightgreen", "green", "darkgreen", "lightblue", "blue", "darkblue", "brown", "cynober", "purple", "darkpurple", "lightgray", "gray", "black"};
        int[] defaultcolorshex = new int[]{0xFFFFFF, 0xFFFF00, 16756075, 0xFF8484, 0xFF0000, 13506601, 0x84FF84, 65280, 50688, 0x8484FF, 255, 198, 0x840000, 65535, 0xFF00FF, 0x840084, 0xCECECE, 0x848484, 8};
        String img_sprites = "sprites.png";
        String img_attr1 = null;
        String img_attr2 = null;
        String img_attr3 = null;
        String img_sword = "sword1.png";
        String img_shield = "shield1.png";
        String img_head = "head19.png";
        String img_body = "body.png";
        String img_param1 = null;
        String color_skin = "orange";
        String color_coat = "white";
        String color_sleeves = "red";
        String color_shoes = "blue";
        String color_belt = "black";
        ArrayList<int[]> rendersprites = new ArrayList<int[]>();
        try {
            int sprite_Y;
            FileReader gani_in = new FileReader(this.getImageLocation(ganiName));
            BufferedReader gani_reader = new BufferedReader(gani_in);
            gani_reader.mark(20480);
            String gani_line = gani_reader.readLine();
            String sprite_scan = gani_reader.readLine();
            int maxsprite = 0;
            int i = 0;
            while (i < 300) {
                this.parsingLine = sprite_scan;
                if (sprite_scan == null || !sprite_scan.startsWith("SPRITE")) break;
                sprite_scan = sprite_scan.replaceAll("\\s+", " ");
                String[] parse = sprite_scan.split("\\s");
                maxsprite = Integer.parseInt(parse[1]);
                sprite_scan = gani_reader.readLine();
                ++i;
            }
            String[][] sprites = new String[maxsprite + 1][5];
            gani_reader.reset();
            boolean foundframe = false;
            while (gani_line != null) {
                this.parsingLine = gani_line;
                if ((gani_line = gani_line.replaceAll("\\s+", " ")).startsWith("SPRITE")) {
                    String[] parse = gani_line.split("\\s");
                    int spritenumber = Integer.parseInt(parse[1]);
                    if (spritenumber < 0 || spritenumber > sprites.length - 1) {
                        gani_line = gani_reader.readLine();
                        continue;
                    }
                    String[] temparr = new String[]{parse[2], parse[3], parse[4], parse[5], parse[6]};
                    sprites[spritenumber] = temparr;
                } else if (gani_line.startsWith("SINGLEDIRECTION")) {
                    dir = 0;
                } else if (gani_line.startsWith("ANI")) {
                    int i2 = 0;
                    while (i2 < dir) {
                        gani_line = gani_reader.readLine();
                        ++i2;
                    }
                    foundframe = true;
                } else if (foundframe) {
                    String[] tokensprites;
                    gani_line = gani_line.replaceAll("\\s+", " ");
                    gani_line = gani_line.replaceAll(",\\s+", ",");
                    gani_line = gani_line.trim();
                    String[] stringArray = tokensprites = gani_line.split(",");
                    int n = tokensprites.length;
                    int temparr = 0;
                    while (temparr < n) {
                        String i3 = stringArray[temparr];
                        String[] tokenspritedata = i3.split(" ");
                        if (Integer.parseInt(tokenspritedata[0]) >= 0) {
                            int[] temparr2 = new int[]{Integer.parseInt((String)tokenspritedata[0]), Integer.parseInt((String)tokenspritedata[1]), Integer.parseInt((String)tokenspritedata[2])};
                            rendersprites.add(temparr2);
                        }
                        ++temparr;
                    }
                    break;
                }
                gani_line = gani_reader.readLine();
            }
            gani_reader.close();
            if (attr[6] != null) {
                img_attr1 = attr[6];
            }
            if (attr[7] != null) {
                img_attr2 = attr[7];
            }
            if (attr[8] != null) {
                img_attr3 = attr[8];
            }
            if (attr[9] != null) {
                img_sword = attr[9];
            }
            if (attr[10] != null) {
                img_shield = attr[10];
            }
            if (attr[11] != null) {
                img_head = attr[11];
            }
            if (attr[12] != null) {
                img_body = attr[12];
            }
            if (attr[13] != null) {
                img_param1 = attr[13];
            }
            if (attr[1] != null) {
                color_skin = attr[1];
            }
            if (attr[2] != null) {
                color_coat = attr[2];
            }
            if (attr[3] != null) {
                color_sleeves = attr[3];
            }
            if (attr[4] != null) {
                color_shoes = attr[4];
            }
            if (attr[5] != null) {
                color_belt = attr[5];
            }
            int sprite_minX = 0;
            int sprite_minY = 0;
            int sprite_maxW = 1;
            int sprite_maxH = 1;
            for (int[] i4 : rendersprites) {
                int sprite_X = i4[1];
                sprite_Y = i4[2];
                if (sprite_X < sprite_minX) {
                    sprite_minX = sprite_X;
                }
                if (sprite_Y >= sprite_minY) continue;
                sprite_minY = sprite_Y;
            }
            if (sprite_minX < 0) {
                this.ganiOffsetx = sprite_minX;
            }
            if (sprite_minY < 0) {
                this.ganiOffsety = sprite_minY;
            }
            for (int[] i4 : rendersprites) {
                int sprite_X = i4[1];
                sprite_Y = i4[2];
                int sprite_W = Integer.parseInt(sprites[i4[0]][3]) + Math.abs(sprite_minX) + sprite_X;
                int sprite_H = Integer.parseInt(sprites[i4[0]][4]) + Math.abs(sprite_minY) + sprite_Y;
                if (sprite_W > sprite_maxW) {
                    sprite_maxW = sprite_W;
                }
                if (sprite_H <= sprite_maxH) continue;
                sprite_maxH = sprite_H;
            }
            if (sprite_maxW < 48) {
                sprite_maxW = 48;
            }
            if (sprite_maxH < 48) {
                sprite_maxH = 48;
            }
            BufferedImage ganiImage = new BufferedImage(sprite_maxW, sprite_maxH, 2);
            Graphics g = ganiImage.getGraphics();
            boolean isbody = false;
            for (int[] i5 : rendersprites) {
                isbody = false;
                String sprite_img = sprites[i5[0]][0];
                int sprite_drawx = i5[1] - this.ganiOffsetx;
                int sprite_drawy = i5[2] - this.ganiOffsety;
                if (sprite_img.equals("SPRITES")) {
                    sprite_img = img_sprites;
                } else if (sprite_img.equals("BODY")) {
                    isbody = true;
                    sprite_img = img_body;
                } else if (sprite_img.equals("HEAD")) {
                    sprite_img = img_head;
                } else if (sprite_img.equals("SWORD")) {
                    sprite_img = img_sword;
                } else if (sprite_img.equals("SHIELD")) {
                    sprite_img = img_shield;
                } else if (sprite_img.equals("ATTR1")) {
                    sprite_img = img_attr1;
                } else if (sprite_img.equals("ATTR2")) {
                    sprite_img = img_attr2;
                } else if (sprite_img.equals("ATTR3")) {
                    sprite_img = img_attr3;
                } else if (sprite_img.equals("PARAM1")) {
                    sprite_img = img_param1;
                }
                try {
                    BufferedImage sprite_render;
                    this.parsingLine = "Rendering image: " + sprite_img;
                    if (sprite_img == null || (sprite_render = ImageIO.read(new File(this.getImageLocation(sprite_img)))) == null) continue;
                    int sprite_sx = Integer.parseInt(sprites[i5[0]][1]);
                    int sprite_sy = Integer.parseInt(sprites[i5[0]][2]);
                    int sprite_sw = Integer.parseInt(sprites[i5[0]][3]);
                    int sprite_sh = Integer.parseInt(sprites[i5[0]][4]);
                    if (isbody) {
                        int[][] bodycolors = new int[][]{{33792, 16756075, 0xFFFFFF, 255, 0xFF0000, 13506601}, {0x300000, 0x400000, 0x500000, 0x600000, 0x700000, 0x800000}};
                        int j = 0;
                        while (j < 6) {
                            sprite_render = this.TransformColorToNewColor(sprite_render, new Color(bodycolors[0][j]), new Color(bodycolors[1][j]));
                            ++j;
                        }
                        int newColor = 0;
                        newColor = defaultcolorshex[this.findColornameValue(defaultcolors, color_skin)];
                        sprite_render = this.TransformColorToNewColor(sprite_render, new Color(bodycolors[1][1]), new Color(newColor));
                        newColor = defaultcolorshex[this.findColornameValue(defaultcolors, color_coat)];
                        sprite_render = this.TransformColorToNewColor(sprite_render, new Color(bodycolors[1][2]), new Color(newColor));
                        newColor = defaultcolorshex[this.findColornameValue(defaultcolors, color_belt)];
                        sprite_render = this.TransformColorToNewColor(sprite_render, new Color(bodycolors[1][3]), new Color(newColor));
                        newColor = defaultcolorshex[this.findColornameValue(defaultcolors, color_sleeves)];
                        sprite_render = this.TransformColorToNewColor(sprite_render, new Color(bodycolors[1][4]), new Color(newColor));
                        newColor = defaultcolorshex[this.findColornameValue(defaultcolors, color_shoes)];
                        sprite_render = this.TransformColorToNewColor(sprite_render, new Color(bodycolors[1][5]), new Color(newColor));
                    }
                    g.drawImage(sprite_render, sprite_drawx, sprite_drawy, sprite_drawx + sprite_sw, sprite_drawy + sprite_sh, sprite_sx, sprite_sy, sprite_sx + sprite_sw, sprite_sy + sprite_sh, null);
                }
                catch (FileNotFoundException e) {
                    this.writeLog(e);
                    this.getListener().sendMessage("Error: Can't find image: " + sprite_img);
                }
                catch (IOException e) {
                    this.writeLog(e);
                    this.getListener().sendMessage("Error: Can't find image: " + sprite_img);
                }
            }
            return ganiImage;
        }
        catch (FileNotFoundException e) {
            this.writeLog(e);
        }
        catch (IOException e) {
            this.writeLog(e);
        }
        return null;
    }

    private int findColornameValue(String[] a, String s) {
        int i = 0;
        while (i < a.length) {
            if (a[i].equals(s)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private int findInt(String s) {
        try {
            int return_val = Integer.parseInt(s);
            return return_val;
        }
        catch (NumberFormatException e) {
            try {
                ScriptEngineManager mgr = new ScriptEngineManager();
                ScriptEngine engine = mgr.getEngineByName("JavaScript");
                double math_val = (Double)engine.eval(s);
                int return_val = (int)math_val;
                return return_val;
            }
            catch (ScriptException e1) {
                this.writeLog(e);
                this.getListener().sendMessage("Warning: Could not parse: " + s);
                return -1;
            }
            catch (NullPointerException e1) {
                this.writeLog(e1);
                this.getListener().sendMessage("Warning: Could not parse: " + s);
                return -1;
            }
        }
    }

    private double findDouble(String s) {
        try {
            double return_val = Double.parseDouble(s);
            return return_val;
        }
        catch (NumberFormatException e) {
            try {
                ScriptEngineManager mgr = new ScriptEngineManager();
                ScriptEngine engine = mgr.getEngineByName("JavaScript");
                double math_val = (Double)engine.eval(s);
                return math_val;
            }
            catch (ScriptException e1) {
                this.writeLog(e);
                this.getListener().sendMessage("Warning: Could not parse: " + s);
                return -1.0;
            }
            catch (NullPointerException e1) {
                this.writeLog(e1);
                this.getListener().sendMessage("Warning: Could not parse: " + s);
                return -1.0;
            }
        }
    }

    private BufferedImage TransformColorToNewColor(BufferedImage image, Color c1, Color c2) {
        final int r1 = c1.getRed();
        final int g1 = c1.getGreen();
        final int b1 = c1.getBlue();
        final int r2 = c2.getRed();
        final int g2 = c2.getGreen();
        final int b2 = c2.getBlue();
        final int a2 = c2.getAlpha();
        RGBImageFilter filter = new RGBImageFilter(){

            @Override
            public final int filterRGB(int x, int y, int argb) {
                int a = 255;
                a = a2 > 0 ? (argb & 0xFF000000) >> 24 : 0;
                int r = (argb & 0xFF0000) >> 16;
                int g = (argb & 0xFF00) >> 8;
                int b = argb & 0xFF;
                if (r != r1 || g != g1 || b != b1) {
                    return argb;
                }
                if (a2 > 0) {
                    a <<= 24;
                }
                r = r2 << 16;
                g = g2 << 8;
                b = b2;
                return a | r | g | b;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(image.getSource(), filter);
        Image new_renderimage = Toolkit.getDefaultToolkit().createImage(ip);
        BufferedImage new_renderbuffer = NW2PNGHelper.toBufferedImage(new_renderimage);
        if (new_renderbuffer == null) {
            return null;
        }
        return new_renderbuffer;
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = true;
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public String getJoin(String s) {
        try {
            FileReader gani_in = new FileReader("ClassImages.txt");
            BufferedReader join_reader = new BufferedReader(gani_in);
            String join_line = join_reader.readLine();
            while (join_line != null) {
                if (join_line.startsWith("//")) {
                    join_line = join_reader.readLine();
                    continue;
                }
                String[] tokens = join_line.split("=");
                if (tokens[0].toLowerCase().equals(s.toLowerCase())) {
                    return tokens[1].toLowerCase();
                }
                join_line = join_reader.readLine();
            }
            join_reader.close();
            return null;
        }
        catch (FileNotFoundException e) {
            this.writeLog(e);
        }
        catch (IOException e) {
            this.writeLog(e);
        }
        return null;
    }

    public void writeLog(String s) {
        try {
            FileWriter fstream = new FileWriter("errorLog.txt", true);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(String.valueOf(s) + "\n");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeLog(Throwable t) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            t.printStackTrace(pw);
            pw.flush();
            sw.flush();
            FileWriter fstream = new FileWriter("errorLog.txt", true);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write("Print Stack Trace for line: " + this.parsingLine + "\n");
            out.write(String.valueOf(sw.toString()) + "\n");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

