/*
 * Decompiled with CFR 0.152.
 */
package src.org.graalcenter.nw2png;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import src.born2kill.nw2png.Listener;
import src.born2kill.nw2png.NW2PNGHelper;

public class GraphicalNW2PNG
implements Listener,
ActionListener {
    NW2PNGHelper helper;
    private boolean isGenerating = false;
    private boolean filterOutput = true;
    private boolean splitImages = false;
    private boolean renderNPCs = true;
    private boolean renderChars = true;
    File tilesetdir;
    File sourcedir;
    File outputdir;
    File graaldir;
    JFrame frame;
    JLabel graaldirLabel;
    JLabel graaldirFileLabel;
    JButton graaldirBrowseButton;
    JLabel tilesetLabel;
    JLabel tilesetFileLabel;
    JButton tilesetBrowseButton;
    JLabel sourceLabel;
    JLabel sourceFileLabel;
    JButton sourceBrowseButton;
    JLabel outputLabel;
    JLabel outputFileLabel;
    JButton outputBrowseButton;
    JLabel scaleLabel;
    JComboBox scaleComboBox;
    JCheckBox filterToggle;
    JCheckBox partimgsToggle;
    JCheckBox rendernpcsToggle;
    JCheckBox rendercharsToggle;
    JScrollPane logScrollPane;
    JTextPane logTextPane;
    JButton generateButton;
    JLabel creditLabel;

    public GraphicalNW2PNG() throws IOException {
        this.LoadDirs();
        this.helper = new NW2PNGHelper(this);
        String installDir = GraphicalNW2PNG.getInstallDir();
        if (installDir == null) {
            JOptionPane.showMessageDialog(null, "I was unable to find your Graal installation directory. You can still use me, but images won't work.");
        }
        this.makeFrame();
        if (installDir != null) {
            if (this.tilesetdir == null) {
                File pics1 = new File(String.valueOf(installDir) + File.separator + "pics1.png");
                if (!pics1.exists()) {
                    pics1 = new File(String.valueOf(installDir) + File.separator + "levels" + File.separator + "tiles" + File.separator + "pics1.png");
                }
                if (pics1.exists()) {
                    this.setTileset(pics1);
                }
            } else {
                this.setTileset(this.tilesetdir);
            }
            if (this.graaldir != null && this.graaldir.isDirectory()) {
                this.setGraalDir(this.graaldir);
            }
            if (this.sourcedir != null && this.sourcedir.isFile()) {
                this.setSource(this.sourcedir);
            }
            if (this.outputdir != null && this.outputdir.isFile()) {
                this.setOutput(this.outputdir);
            }
        }
    }

    private void setGraalDir(File file) {
        this.helper.setGraalDir(file.getAbsolutePath());
        this.graaldir = file;
        this.graaldirFileLabel.setText(file.getAbsolutePath());
        this.SaveDirs();
        this.updateGenerateButton();
    }

    private void setTileset(File file) {
        try {
            this.helper.setTileset(file);
            this.tilesetdir = file;
            this.tilesetFileLabel.setText(file.getName());
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, "Can't load the image file. Sorry.");
        }
        this.SaveDirs();
        this.updateGenerateButton();
    }

    private void setSource(File file) {
        this.helper.setSourceFile(file);
        this.sourcedir = file;
        this.sourceFileLabel.setText(file.getName());
        this.SaveDirs();
        this.updateGenerateButton();
    }

    private void setOutput(File file) {
        this.outputdir = file;
        if (!file.getName().endsWith(".png")) {
            file = new File(file.getAbsoluteFile() + ".png");
        }
        this.helper.setOutputFile(file);
        this.outputFileLabel.setText(file.getName());
        this.SaveDirs();
        this.updateGenerateButton();
    }

    private void LoadDirs() {
        String fFileName = "saveddirs.txt";
        try {
            FileReader dirs_in = new FileReader(fFileName);
            BufferedReader dirs_reader = new BufferedReader(dirs_in);
            String dir_line = dirs_reader.readLine();
            while (dir_line != null) {
                String dirname;
                if (dir_line.startsWith("tilesetdir=")) {
                    dirname = dir_line.substring(dir_line.indexOf("=") + 1);
                    if (dir_line.indexOf("null") < 0) {
                        this.tilesetdir = new File(dirname);
                    }
                }
                if (dir_line.startsWith("sourcedir=")) {
                    dirname = dir_line.substring(dir_line.indexOf("=") + 1);
                    if (dir_line.indexOf("null") < 0) {
                        this.sourcedir = new File(dirname);
                    }
                }
                if (dir_line.startsWith("outputdir=")) {
                    dirname = dir_line.substring(dir_line.indexOf("=") + 1);
                    if (dir_line.indexOf("null") < 0) {
                        this.outputdir = new File(dirname);
                    }
                }
                if (dir_line.startsWith("graaldir=")) {
                    dirname = String.valueOf(dir_line.substring(dir_line.indexOf("=") + 1)) + "\\";
                    if (dir_line.indexOf("null") < 0) {
                        this.graaldir = new File(dirname);
                    }
                }
                if (dir_line.startsWith("filterOutput=")) {
                    dirname = dir_line.substring(dir_line.indexOf("=") + 1);
                    if (dir_line.indexOf("null") < 0) {
                        this.filterOutput = Boolean.parseBoolean(dirname);
                    }
                }
                if (dir_line.startsWith("splitImages=")) {
                    dirname = dir_line.substring(dir_line.indexOf("=") + 1);
                    if (dir_line.indexOf("null") < 0) {
                        this.splitImages = Boolean.parseBoolean(dirname);
                    }
                }
                if (dir_line.startsWith("renderNPCs=")) {
                    dirname = dir_line.substring(dir_line.indexOf("=") + 1);
                    if (dir_line.indexOf("null") < 0) {
                        this.renderNPCs = Boolean.parseBoolean(dirname);
                    }
                }
                if (dir_line.startsWith("renderChars=")) {
                    dirname = dir_line.substring(dir_line.indexOf("=") + 1);
                    if (dir_line.indexOf("null") < 0) {
                        this.renderChars = Boolean.parseBoolean(dirname);
                    }
                }
                dir_line = dirs_reader.readLine();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void SaveDirs() {
        String fFileName = "saveddirs.txt";
        try {
            OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(fFileName));
            out.write("tilesetdir=" + this.tilesetdir + "\n");
            out.write("sourcedir=" + this.sourcedir + "\n");
            out.write("outputdir=" + this.outputdir + "\n");
            out.write("graaldir=" + this.graaldir + "\n");
            out.write("filterOutput=" + this.filterOutput + "\n");
            out.write("splitImages=" + this.splitImages + "\n");
            out.write("renderNPCs=" + this.renderNPCs + "\n");
            out.write("renderChars=" + this.renderChars + "\n");
            ((Writer)out).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void updateGenerateButton() {
        this.generateButton.setEnabled(this.helper.getTileset() != null && this.helper.getSourceFile() != null && this.helper.getOutputFile() != null && !this.isGenerating);
    }

    private void makeFrame() {
        this.frame = new JFrame("NW2PNG");
        this.frame.setMinimumSize(new Dimension(500, 400));
        this.frame.setPreferredSize(new Dimension(500, 400));
        this.frame.setLocationRelativeTo(null);
        this.frame.setLayout(new GridBagLayout());
        this.frame.setDefaultCloseOperation(3);
        Container pane = this.frame.getContentPane();
        JPanel topPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.gridx = 0;
        constraints.gridy = 0;
        int padding = 10;
        constraints.insets = new Insets(padding, padding, padding, padding);
        pane.add((Component)topPanel, constraints);
        this.graaldirLabel = new JLabel("Graal Dir:");
        this.graaldirLabel.setHorizontalAlignment(4);
        constraints = new GridBagConstraints();
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 1, 5);
        topPanel.add((Component)this.graaldirLabel, constraints);
        this.graaldirFileLabel = new JLabel("<none>");
        this.graaldirFileLabel.setHorizontalAlignment(2);
        constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 1, 0);
        topPanel.add((Component)this.graaldirFileLabel, constraints);
        this.graaldirBrowseButton = new JButton("Browse");
        this.graaldirBrowseButton.addActionListener(this);
        constraints = new GridBagConstraints();
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 1, 0);
        topPanel.add((Component)this.graaldirBrowseButton, constraints);
        this.tilesetLabel = new JLabel("Tileset:");
        this.tilesetLabel.setHorizontalAlignment(4);
        constraints = new GridBagConstraints();
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(0, 0, 1, 5);
        topPanel.add((Component)this.tilesetLabel, constraints);
        this.tilesetFileLabel = new JLabel("<none>");
        this.tilesetFileLabel.setHorizontalAlignment(2);
        constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.insets = new Insets(0, 0, 1, 0);
        topPanel.add((Component)this.tilesetFileLabel, constraints);
        this.tilesetBrowseButton = new JButton("Browse");
        this.tilesetBrowseButton.addActionListener(this);
        constraints = new GridBagConstraints();
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.insets = new Insets(0, 0, 1, 0);
        topPanel.add((Component)this.tilesetBrowseButton, constraints);
        this.sourceLabel = new JLabel("Source:");
        this.sourceLabel.setHorizontalAlignment(4);
        constraints = new GridBagConstraints();
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.insets = new Insets(0, 0, 1, 5);
        topPanel.add((Component)this.sourceLabel, constraints);
        this.sourceFileLabel = new JLabel("<none>");
        this.sourceFileLabel.setHorizontalAlignment(2);
        constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.insets = new Insets(0, 0, 1, 0);
        topPanel.add((Component)this.sourceFileLabel, constraints);
        this.sourceBrowseButton = new JButton("Browse");
        this.sourceBrowseButton.addActionListener(this);
        constraints = new GridBagConstraints();
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.gridx = 2;
        constraints.gridy = 2;
        constraints.insets = new Insets(0, 0, 1, 0);
        topPanel.add((Component)this.sourceBrowseButton, constraints);
        this.outputLabel = new JLabel("Output:");
        this.outputLabel.setHorizontalAlignment(4);
        constraints = new GridBagConstraints();
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.insets = new Insets(0, 0, 5, 5);
        topPanel.add((Component)this.outputLabel, constraints);
        this.outputFileLabel = new JLabel("<none>");
        this.outputFileLabel.setHorizontalAlignment(2);
        constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.insets = new Insets(0, 0, 5, 0);
        topPanel.add((Component)this.outputFileLabel, constraints);
        this.outputBrowseButton = new JButton("Browse");
        this.outputBrowseButton.addActionListener(this);
        constraints = new GridBagConstraints();
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.gridx = 2;
        constraints.gridy = 3;
        constraints.insets = new Insets(0, 0, 5, 0);
        topPanel.add((Component)this.outputBrowseButton, constraints);
        this.scaleLabel = new JLabel("Scale:");
        this.scaleLabel.setHorizontalAlignment(4);
        constraints = new GridBagConstraints();
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.insets = new Insets(0, 0, 5, 5);
        topPanel.add((Component)this.scaleLabel, constraints);
        String[] options = new String[]{"100%", "75%", "50%", "35%", "25%", "20%", "10%"};
        this.scaleComboBox = new JComboBox<String>(options);
        constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.gridwidth = 2;
        constraints.insets = new Insets(0, 0, 5, 0);
        topPanel.add((Component)this.scaleComboBox, constraints);
        this.logTextPane = new JTextPane();
        this.logTextPane.setEditable(false);
        this.logScrollPane = new JScrollPane(this.logTextPane);
        this.logScrollPane.setVerticalScrollBarPolicy(22);
        constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 3;
        constraints.insets = new Insets(0, 0, 5, 0);
        topPanel.add((Component)this.logScrollPane, constraints);
        this.filterToggle = new JCheckBox("Filter Output");
        this.filterToggle.addActionListener(this);
        constraints = new GridBagConstraints();
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.gridwidth = 0;
        constraints.insets = new Insets(0, 0, 5, 0);
        topPanel.add((Component)this.filterToggle, constraints);
        this.partimgsToggle = new JCheckBox("Split Images");
        this.partimgsToggle.addActionListener(this);
        constraints = new GridBagConstraints();
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 6;
        constraints.gridwidth = 0;
        constraints.insets = new Insets(0, 35, 5, 0);
        topPanel.add((Component)this.partimgsToggle, constraints);
        this.rendernpcsToggle = new JCheckBox("Render NPCs");
        this.rendernpcsToggle.addActionListener(this);
        constraints = new GridBagConstraints();
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 6;
        constraints.gridwidth = 0;
        constraints.insets = new Insets(0, 117, 5, 0);
        topPanel.add((Component)this.rendernpcsToggle, constraints);
        this.rendercharsToggle = new JCheckBox("Render Characters");
        this.rendercharsToggle.addActionListener(this);
        constraints = new GridBagConstraints();
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 6;
        constraints.gridwidth = 0;
        constraints.insets = new Insets(0, 205, 5, 0);
        topPanel.add((Component)this.rendercharsToggle, constraints);
        this.generateButton = new JButton("Generate");
        this.generateButton.addActionListener(this);
        constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.gridwidth = 3;
        constraints.insets = new Insets(0, 0, 5, 0);
        topPanel.add((Component)this.generateButton, constraints);
        this.creditLabel = new JLabel("<html><p align=\"left\">Originally written by Alex (born2kill). Modifications by Dusty and Chris Vimes.GUI by Chris Vimes.</p></html>");
        constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 13;
        constraints.gridx = 0;
        constraints.gridy = 7;
        constraints.gridwidth = 3;
        topPanel.add((Component)this.creditLabel, constraints);
        this.updateGenerateButton();
        this.filterToggle.setSelected(this.filterOutput);
        this.helper.setFilter(this.filterOutput);
        this.partimgsToggle.setSelected(this.splitImages);
        this.helper.setSplit(this.splitImages);
        this.rendernpcsToggle.setSelected(this.renderNPCs);
        this.helper.setRenderNPCs(this.renderNPCs);
        this.rendercharsToggle.setSelected(this.renderChars);
        this.helper.setRenderNPCs(this.renderChars);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public static void main(String[] args) throws IOException {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        new GraphicalNW2PNG();
    }

    private static String getInstallDir() {
        String[] tryDirs;
        String userDir = System.getProperty("user.home");
        String[] stringArray = tryDirs = new String[]{String.valueOf(userDir) + File.separator + ".graal" + File.separator + "graal4", String.valueOf(userDir) + File.separator + "Library" + File.separator + "Application Support" + File.separator + "Graal", String.valueOf(File.separator) + "Graal", String.valueOf(File.separator) + "Program Files" + File.separator + "Graal", String.valueOf(File.separator) + "Program Files (x86)" + File.separator + "Graal", String.valueOf(userDir) + File.separator + "Graal", String.valueOf(userDir) + File.separator + "Documents" + File.separator + "Graal", String.valueOf(userDir) + File.separator + "My Saved Games" + File.separator + "Graal", String.valueOf(userDir) + File.separator + "Desktop" + File.separator + "Graal"};
        int n = tryDirs.length;
        int n2 = 0;
        while (n2 < n) {
            String tryDir = stringArray[n2];
            File options = new File(String.valueOf(tryDir) + File.separator + "game_config.txt");
            if (options.exists()) {
                return tryDir;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void sendMessage(String message) {
        String timeStamp = this.getTimeStamp();
        if (this.logTextPane.getText().length() > 0) {
            this.logTextPane.setText(String.valueOf(this.logTextPane.getText()) + "\n");
        }
        this.logTextPane.setText(String.valueOf(this.logTextPane.getText()) + "[" + timeStamp + "]: " + message);
        this.logTextPane.setCaretPosition(this.logTextPane.getDocument().getLength());
    }

    public String getTimeStamp() {
        Date myDate = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        return sdf.format(myDate);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int returnVal;
        JFileChooser fc;
        Component object = (Component)e.getSource();
        if (object == this.graaldirBrowseButton) {
            fc = new JFileChooser();
            fc.setFileSelectionMode(1);
            fc.setCurrentDirectory(this.graaldir);
            returnVal = fc.showOpenDialog(object);
            if (returnVal == 0) {
                this.setGraalDir(fc.getSelectedFile());
            }
        }
        if (object == this.tilesetBrowseButton) {
            fc = new JFileChooser();
            fc.setCurrentDirectory(this.tilesetdir);
            returnVal = fc.showOpenDialog(object);
            if (returnVal == 0) {
                this.setTileset(fc.getSelectedFile());
            }
        } else if (object == this.sourceBrowseButton) {
            fc = new JFileChooser();
            fc.setCurrentDirectory(this.sourcedir);
            returnVal = fc.showOpenDialog(object);
            if (returnVal == 0) {
                this.setSource(fc.getSelectedFile());
            }
        } else if (object == this.outputBrowseButton) {
            fc = new JFileChooser();
            fc.setCurrentDirectory(this.outputdir);
            returnVal = fc.showSaveDialog(object);
            if (returnVal == 0) {
                this.setOutput(fc.getSelectedFile());
            }
        } else if (object == this.filterToggle) {
            this.filterOutput = this.filterToggle.isSelected();
            this.helper.setFilter(this.filterOutput);
        } else if (object == this.partimgsToggle) {
            this.splitImages = this.partimgsToggle.isSelected();
            this.helper.setSplit(this.splitImages);
        } else if (object == this.rendernpcsToggle) {
            this.renderNPCs = this.rendernpcsToggle.isSelected();
            this.helper.setRenderNPCs(this.renderNPCs);
        } else if (object == this.rendercharsToggle) {
            this.renderNPCs = this.rendercharsToggle.isSelected();
            this.helper.setRenderChars(this.renderChars);
        } else if (object == this.generateButton) {
            this.SaveDirs();
            String scaletext = this.scaleComboBox.getSelectedItem().toString();
            double scalevalue = Double.parseDouble(scaletext.substring(0, scaletext.indexOf("%")));
            double scale = scalevalue / 100.0;
            this.helper.setScale(scale);
            this.isGenerating = true;
            this.updateGenerateButton();
            this.logTextPane.setText("");
            this.sendMessage("Generating...");
            this.helper.generate();
        }
    }

    @Override
    public void doneGenerating() {
        this.isGenerating = false;
        this.updateGenerateButton();
    }
}

